
-- constants for the player states
local STATE_IDLE = 1
local STATE_MOVING = 2
local STATE_MOVING_LEFT = 1
local STATE_MOVING_RIGHT = 2
local STATE_FIRING = 3
local beat = 0
local beat2 = 0
local beat3 = 0
local beat4 = 0
local ENEMY_SPEED = 20
local MIN_FIRE_RATE = 9
local ENEMY_SIZE = 0.3
local ENEMY_WIDTH = 25
local ENEMY_HEIGHT = 50
local MAX_BULLETS = 8
local g = {
  -- create a table to store the players
  Players = {
    {
      pos = {
        dir = "Right",
        x = SCREEN_WIDTH / 4,
        y = SCREEN_HEIGHT - 32
      },
      state = STATE_IDLE,
      actor = nil,
      alive = true,
      Lives = 3,
      input = {
        Active    = nil,
        Up        = false,
        Down      = false,
        Left      = false,
        Right     = false,
        MenuRight = false,
        MenuLeft  = false,
        Start     = false,
        Select    = false,
      },
    },
    {
      pos = {
        dir = "Left",
        x = 3*SCREEN_WIDTH / 4,
        y = SCREEN_HEIGHT - 32
      },
      state = STATE_IDLE,
      actor = nil,
      alive = true,
      Lives = 3,
      input = {
        Active    = nil,
        Up        = false,
        Down      = false,
        Left      = false,
        Right     = false,
        MenuRight = false,
        MenuLeft  = false,
        Start     = false,
        Select    = false,
      },
    }
    
  },  
  -- create a table to store the enemies
  Enemies = {},
  Bullets = {}
}

VictoryCheck = function(self)
  if g.Players[1].Lives <= 0 and g.Players[2].Lives <= 0 then
    return false
  end
  for j=1,#g.Enemies do
    if g.Enemies[j] ~= nil then
        if g.Enemies[j].alive then
          return false; 
        end
    end
  end
  return true;
end
local BulletActors = {}
local numBullets = 0;
local counter2 = 0


-- create a function to update the player bullet position
function updatePlayerBullet(i, dt)
  g.Bullets[i].y = g.Bullets[i].actor:GetY()
 -- g.Bullets.actor:playcommand("Check")
end

-- create a function to update all the player bullets
function updatePlayerBullets(dt)
  for i = 1, #g.Bullets do
    -- Dont check dead bullets
    if g.Bullets[i] == nil then
      return
    end
    updatePlayerBullet(i, dt)
    checkPlayerBulletCollisions(i)
  end
end

-- create a function to create a new player bullet
function createPlayerBullet(x, y, direction, speed)
  numBullets = numBullets + 1
  char_sans_gptr = char_sans_gptr+1
	if numBullets > #BulletActors then
    numBullets = 1
  end
  local bullet = {
    x = x,
    y = y,
    direction = direction,
    speed = speed,
    actor = BulletActors[numBullets]
  }
  bullet.actor:x(bullet.x):y(bullet.y)
  table.insert(g.Bullets, bullet)
  return bullet.actor
end

-- press START to trigger an event 
function fireBullet(pn)
  if (GAMESTATE:GetSongBeat() - beat2) > 0.3 then
    beat2 = GAMESTATE:GetSongBeat()
    if #g.Bullets < MAX_BULLETS then
      local a = createPlayerBullet(g.Players[pn].pos.x, g.Players[pn].pos.y, -1, 100)
      DoBulletSound()
      a:rotationz(0)
      a:visible(true);
      a:zoom(0.05);
      a:decelerate(2);
      a:x(g.Bullets[#g.Bullets].x);
      a:y(-50);
      a:rotationz(720);
      a:queuecommand('Reset');
    else
      SM("Max Bullets")
    end
  end
end


-- create a function to check for collisions between player bullets and enemies
function checkPlayerBulletCollisions(i)
    if g.Bullets[i].y < 0 or g.Bullets[i].y > SCREEN_HEIGHT then
      -- if the bullet is off the screen, remove it
      table.remove(g.Bullets, i)
      return
    end
    local enemiesToRemove = {}
    for j=1,#g.Enemies do
      local enemy = g.Enemies[j]
        -- use simple rectangular collision detection to check for a collision
        if enemy.alive ~= false then
          if g.Bullets[i].x >= enemy.actor:GetX() - ENEMY_WIDTH and g.Bullets[i].x < enemy.actor:GetX() + ENEMY_WIDTH and
          g.Bullets[i].y >= enemy.actor:GetY() - ENEMY_HEIGHT and g.Bullets[i].y < enemy.actor:GetY() + ENEMY_HEIGHT then
          g.Enemies[i].alive = false
          -- if a collision is detected, remove both the bullet and the enemy
          --table.remove(g.Bullets, i)
          table.insert(enemiesToRemove, j)
        end
      end

    end
    -- remove the enemies that were hit
    for i,v in ipairs(enemiesToRemove) do 
      g.Enemies[v].alive = false
      
    end

end
-- Check if blast from Nth enemy hits player
local PLAYER_WIDTH = 50
function checkBlastCollision(n)
    for i = 1,2 do
        -- use simple rectangular collision detection to check for a collision
        if g.Enemies[n].pos.x >= g.Players[i].pos.x - PLAYER_WIDTH and g.Enemies[n].pos.x < g.Players[i].pos.x + PLAYER_WIDTH then
          -- if a collision is detected, remove both the bullet and the player
        --   table.remove(enemyBullets, i)
        --   table.remove(players, j)
          -- If a collision is detected, decrease the player's lives
          g.Players[i].Lives = g.Players[i].Lives - 1
          g.Players[i].actor:playcommand("Hit")
          if g.Players[i].Lives <= 0 then
            g.Players[i].alive = false
            g.Players[i].actor:accelerate(1):addy(100):diffusealpha(0)
          else
            SM("Player "..i.." Hit, " .. g.Players[i].Lives .. " Lives Left")
          end
        end
    end
end
local fireGaster = function(i)
  local a = g.Enemies[i].actor
    a:rotationz(0);
    a:zoom(1.5*ENEMY_SIZE);
    a:decelerate(0.5);
    a:rotationz(720);
    a:sleep(0.5);
    a:rotationz(0);
    a:queuecommand('Fire');
    a:sleep(0.3)
    checkBlastCollision(i)
    a:accelerate(0.5)
    a:sleep(0.3); 
    a:queuecommand('Reset');
end


-- create a function to update the enemy state machine
function updateEnemy(i, dt)
  if g.Enemies[i].alive == false and not g.Enemies[i].dead then
    g.Enemies[i].actor:GetParent():queuecommand("Hit")
    g.Enemies[i].dead = true
    DoRandomSound()
    return;
  end
  if g.Enemies[i].dead then
    return;
  end
  -- update the firing timer
  g.Enemies[i].timer = g.Enemies[i].timer - dt
  -- if the timer has expired, fire a bullet and switch back to the moving state
  if g.Enemies[i].timer <= 0 then
    g.Enemies[i].movingState = g.Enemies[i].state
    g.Enemies[i].state = STATE_FIRING
    g.Enemies[i].timer = math.random(MIN_FIRE_RATE,20)
  end
  -- Randomly change the enemy's state
  if math.random() < 0.3 then
    g.Enemies[i].state = math.random(STATE_MOVING_LEFT, STATE_MOVING_RIGHT)
  end
  if g.Enemies[i].state == STATE_MOVING_LEFT then
    -- move the enemy to the left
    g.Enemies[i].pos.x = g.Enemies[i].pos.x - ENEMY_SPEED*(0.5+math.random()*2) * dt
    
    -- if the enemy has reached the left edge of the screen, change to the right state
    if g.Enemies[i].pos.x < SCREEN_WIDTH/20 then
      g.Enemies[i].state = STATE_MOVING_RIGHT
    end
    g.Enemies[i].movingState = g.Enemies[i].state
  elseif g.Enemies[i].state == STATE_MOVING_RIGHT then
    -- move the enemy to the right
    g.Enemies[i].pos.x = g.Enemies[i].pos.x + ENEMY_SPEED *(0.5+math.random()*2) * dt
    
    -- if the enemy has reached the right edge of the screen, change to the left state
    if g.Enemies[i].pos.x > 19*SCREEN_WIDTH/20 then
      g.Enemies[i].state = STATE_MOVING_LEFT
    end
    g.Enemies[i].movingState = g.Enemies[i].state
  elseif g.Enemies[i].state == STATE_FIRING then
        g.Enemies[i].state = g.Enemies[i].movingState
      -- fire a bullet
      fireGaster(i)
  end
  if g.Enemies[i].actor then
    g.Enemies[i].actor:queuecommand("Check")

  end

end

-- create a function to update all the enemies
function updateEnemies(dt)
  for i = 1, #g.Enemies do
    updateEnemy(i, dt)
  end
end

local InputHandler = function(event)

-- if any of these, don't attempt to handle input
if not event.PlayerNumber or not event.button then return false end
local pn = tonumber(string.match(event.PlayerNumber, "[0-9]+"))


if g.InputIsLocked then return false end
if event.type == "InputEventType_FirstPress" then
      if event.button == "Up" then
          -- fire bullet
          if g.Players[pn].alive then
            fireBullet(pn)
          end
      end
      if event.button == "Right" then
        g.Players[pn].pos.dir = "Right"
        g.Players[pn].state = STATE_MOVING
      elseif event.button == "Left" then
        g.Players[pn].pos.dir = "Left"
        g.Players[pn].state = STATE_MOVING
      else
        g.Players[pn].state = STATE_IDLE
      end
elseif event.type == "InputEventType_Repeat" then
  if event.button == "Right" then
    g.Players[pn].pos.dir = "Right"
    g.Players[pn].state = STATE_MOVING
  elseif event.button == "Left" then
    g.Players[pn].pos.dir = "Left"
    g.Players[pn].state = STATE_MOVING
  else
    g.Players[pn].state = STATE_IDLE
  end
elseif event.type == "InputEventType_Release" then

  -- if the button just released was the most recently active button, then no button is being held
  if event.button == g.Players[pn].input.Active then
    g.Players[pn].state = STATE_IDLE
    -- so mark the Active field as nil
    g.Players[pn].input.Active = nil
    -- and inform the player sprite to stop animating
    g.Players[pn].actor:queuecommand("AnimationOff")
  end

  -- either way, this button has been released, so mark it as false
  g.Players[pn].input[event.button] = false
end

return false
end


local checked = false
--main loop
function handler_update()
    if GAMESTATE:GetSongBeat() >= 0.1 and not checked then

      screen = SCREENMAN:GetTopScreen()

      checked = true;

  end

  if ((GAMESTATE:GetSongBeat() - beat3) > 0.05) then
    beat3 = GAMESTATE:GetSongBeat()
    updatePlayerBullets(1)
  end
  if ((GAMESTATE:GetSongBeat() - beat) > 1) then
    beat = GAMESTATE:GetSongBeat()
    updateEnemies(1)
  end
end
function handler_init()

  
end
local t = Def.ActorFrame{
	OnCommand= function(self)
    handler_init()
    self:SetUpdateFunction(handler_update)
    SCREENMAN:GetTopScreen():AddInputCallback(InputHandler)
  end,
}


t[#t+1] = Def.ActorFrame{
	Def.Quad{
		Name= "I may be sleeping, but I preserve the world.",
		InitCommand= cmd(visible,false),
		OnCommand= cmd(sleep,1000),
	},
  Def.ActorFrame{
    OnCommand=cmd(visible,true;sleep,0.02;queuecommand,"SetMe"),
    SetMeCommand=function(self)
        g.Players[1].actor = self
        self:x(g.Players[1].pos.x):y(g.Players[1].pos.y)
    end,
    StepMessageCommand=function(self, params)
      if params.PlayerNumber == PLAYER_1 then
        local pn = ToEnumShortString(params.PlayerNumber)

        -- DOWN or RIGHT
        if (params.Column == 1 or params.Column == 3) and self:GetX() < _screen.w - self:GetWidth()/2 then
          self:x( self:GetX() + 14 )
        -- UP or LEFT
        elseif (params.Column == 2 or params.Column == 0) and self:GetX() > self:GetWidth()/2 then
          self:x( self:GetX() - 14 )
        end
        g.Players[1].pos.x = self:GetX()
        if g.Players[1].alive then

          g.Players[1].pos.y = SCREEN_HEIGHT - 32
        end
      end
    end,
    CheckCommand=function(self, params)
        if g.Players[1].state == STATE_FIRING then
            self:playcommand("Fire")
        else
            self:playcommand("Reset")
        end

    end,
    HitCommand = function(self)
      self:rotationz(0);
      self:decelerate(0.5);
      self:diffusealpha(0.2):rotationz(360);
      self:sleep(0.1);
      self:linear(0.5):diffusealpha(1)

    end,
    DoneCommand=cmd(visible,false),
    LoadActor( "sans/GretaUFO.png" )..{
        InitCommand=function (self)
            self:SetTextureFiltering(false):zoom(0.2)
        end,
        -- OnCommand=cmd(animate,0;setstate,0),
        -- FireCommand=cmd(setstate,1;zoom,1.3;decelerate,0.2;addy,-10;zoom,1;),
        -- ResetCommand=cmd(y,0;setstate,0)
    },
    Def.Quad{
        InitCommand=function (self)
            self:SetTextureFiltering(false);
            self:diffuse(Color.Red):addx(-15)
        end,
        OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
        FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,27;linear,0.6;zoomx,18;accelerate,0.6;zoomx,0;diffusealpha,-0.2)
    },
    Def.Quad{
        InitCommand=function (self)
            self:SetTextureFiltering(false);
            self:diffuse(Color.Red):addx(20)
        end,
        OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
        FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,27;linear,0.6;zoomx,18;accelerate,0.6;zoomx,0;diffusealpha,-0.2)
    },
  },
  Def.ActorFrame{
    OnCommand=cmd(visible,true;sleep,0.02;queuecommand,"SetMe"),
    SetMeCommand=function(self)
        g.Players[2].actor = self
        self:x(g.Players[2].pos.x):y(g.Players[2].pos.y)
    end,
    CheckCommand=function(self)
        if g.Players[2].state == STATE_FIRING then
            self:playcommand("Fire")
        else
            self:playcommand("Reset")
        end
    end,
    StepMessageCommand=function(self, params)
      if params.PlayerNumber == PLAYER_2 then
        local pn = ToEnumShortString(params.PlayerNumber)

        -- DOWN or RIGHT
        if (params.Column == 1 or params.Column == 3) and self:GetX() < _screen.w - self:GetWidth()/2 then
          self:x( self:GetX() + 14 )
        -- UP or LEFT
        elseif (params.Column == 2 or params.Column == 0) and self:GetX() > self:GetWidth()/2 then
          self:x( self:GetX() - 14 )
        end
        g.Players[2].pos.x = self:GetX()
        if g.Players[2].alive then

          g.Players[2].pos.y = SCREEN_HEIGHT - 32
        end
      end
    end,
    HitCommand = function(self)
      self:stoptweening():rotationz(0);
      self:decelerate(0.5);
      self:diffusealpha(0.2):rotationz(360);
      self:sleep(0.1);
      self:linear(0.5):diffusealpha(1)

    end,
    DoneCommand=cmd(visible,false),
    LoadActor( "sans/GretaUFO.png" )..{
        InitCommand=function (self)
            self:SetTextureFiltering(false):zoom(0.2);
        end,
        -- OnCommand=cmd(animate,0;setstate,0),
        -- FireCommand=cmd(setstate,1;zoom,1.3;decelerate,0.2;addy,-10;zoom,1;),
        -- ResetCommand=cmd(y,0;setstate,0)
    },
    Def.Quad{
        InitCommand=function (self)
            self:SetTextureFiltering(false);
            self:diffuse(Color.Red):addx(-15)
        end,
        OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
        FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,27;linear,0.6;zoomx,18;accelerate,0.6;zoomx,0;diffusealpha,-0.2)
    },
    Def.Quad{
        InitCommand=function (self)
            self:SetTextureFiltering(false);
            self:diffuse(Color.Red):addx(20)
        end,
        OnCommand=cmd(vertalign,top;y,-14;zoomx,0;zoomy,10000;diffusealpha,1;),
        FireCommand=cmd(diffusealpha,1;zoomx,0;spring,0.4;zoomx,27;linear,0.6;zoomx,18;accelerate,0.6;zoomx,0;diffusealpha,-0.2)
    },
  }
}

t[#t+1] =  LoadActor( "Enemy.lua", {g})
for i=1,15 do
  t[#t+1] = Def.ActorFrame{
      OnCommand=cmd(visible,false;sleep,0.02;queuecommand,"SetMe"),
      CheckCommand=function(self)
          --SM("Enemy "..i.." is at "..g.Enemies[i].pos.x..","..g.Enemies[i].pos.y .. "\n and is "..g.Enemies[i].state .. " and has "..g.Enemies[i].timer.." seconds left") 
          self:linear(0.5):x(g.Bullets.x):y(g.Bullets.y)
      end,
      SetMeCommand=function(self)
            BulletActors[i] = self
            self:zoom(0.15)
      end,
      DoneCommand=cmd(visible,true),
      LoadActor( "pizza.png" )..{
          InitCommand=function (self)
              self:SetTextureFiltering(false);
          end,
          OnCommand=cmd(animate,0;setstate,0),
          FireCommand=cmd(setstate,1;zoom,0.2;decelerate,0.2;addy,-10;zoom,0.15;),
          ResetCommand=cmd(y,0;setstate,0)
      },
    }
  end

  t[#t + 1] = Def.ActorFrame {
    LoadActor("Trophy.png")..{
      InitCommand= function(self)
          self:visible(false)
          local src_w = self:GetTexture():GetSourceWidth()
          self:Center():zoom(0.1*2)
        end,
          CollectMessageCommand=function(self)
              self:visible(true):linear(1):diffusealpha(1)
              self:bounce():effectmagnitude(0,-20,0):effectperiod(0.3871):addx(SCREEN_CENTER_X/6)
          end,
          CollectEndMessageCommand=function(self)
              self:linear(7):Center():zoom(0.4*2)
          end,
          CollectPreEndMessageCommand=function(self)
              self:bounce():effectmagnitude(0,0,0);
          end,
    },
    Def.Quad{
      OnCommand=function(self)
        self:FullScreen():Center()
        self:diffuse(0,0,0,0)
      end,
      FlashMessageCommand= function(self)
        self:diffuse(Color.White)
        self:linear(2):diffuse(0,0,0,0);
      end,
    },
      Def.Quad{
      OnCommand=function(self)
        self:FullScreen():Center()
        self:diffuse(0,0,0,0)
      end,
      CollectEndMessageCommand= function(self)
        self:diffuse(0,0,0,0)
              self:linear(7):diffuse(Color.White);
      end,
    },
    Def.Sprite{
      Texture='TateVictory.jpg',
          InitCommand= function(self)
        self:visible(false):diffusealpha(0)
        local src_w = self:GetTexture():GetSourceWidth()
        self:Center():FullScreen()
      end,
      SavedMessageCommand=function(self)
        self:visible(true):linear(3):diffusealpha(1)
        if VictoryCheck() then
          self:visible(true):linear(3):diffusealpha(1)
        else
          self:visible(false)
        end
      end
    },
    Def.Sprite{
      Texture='TateLoss.jpg',
          InitCommand= function(self)
        self:visible(false):diffusealpha(0)
        local src_w = self:GetTexture():GetSourceWidth()
        self:Center():FullScreen()
      end,
      SavedMessageCommand=function(self)
        if not VictoryCheck() then
          self:visible(true):linear(3):diffusealpha(1)
        else
          self:visible(false)
        end
      end
    },
    Def.Sprite{
      Texture ='../dancing-tate 8x8.png';
      InitCommand = function(self) tateo= self; end;
      OnCommand = function(self)
        self:visible(false):Center():x(7*SCREEN_WIDTH/8):y(14*SCREEN_HEIGHT/20)
              self:SetAllStateDelays(0.04):zoom(0.4):animate(false):diffusealpha(0)
      end,
      SavedMessageCommand=function(self)
        if not VictoryCheck() then
            self:visible(true):sleep(3):linear(3):diffusealpha(1):animate(true)
        end
      end,

    },
  }
return t